#############################################################################
# Gui UG Module by Krayy
#############################################################################
# Ver 1.0.1 - 05 March 2010 Initial release
#############################################################################

CatchEvent OnLapperStart()
	# CifRegisterModule("Group_Name", "Module Name", MODULE_VERSION);
	CifRegisterModule("Info", "Who", "1.01");
EndCatchEvent

CatchEvent OnMSO( $userName, $text ) # Player event
	$idxOfFirstSpace = indexOf( $text, " ");
	IF( $idxOfFirstSpace == -1 ) THEN
	  $command = $text;
	  $argv = "";
	ELSE
	  $command = subStr( $text,0,$idxOfFirstSpace );
	  $argv = trim( subStr( $text,$idxOfFirstSpace ) );
	ENDIF

	SWITCH( $command )
		CASE "!who":
			DoCifInfoWho(0,0);
   		BREAK;
	ENDSWITCH
EndCatchEvent

Sub DoCifInfoWho($KeyFlags,$id)
	# Set default values for the module - these MUST be the same as the main Do function name
	$cifGroupName="Info";
	$cifModuleName="Who";
	$DialogPrefix = "CIF" . $cifGroupName . $cifModuleName . "_";

	# Draw the CIF dialog box
	CifDraw($cifGroupName, $cifModuleName, "Who");

	# Set various vars for GUI size and location
	$origT = $CifOrigT+1;			# Top edge of main content window
	$origL = $CifOrigL+1;	# Left edge of main content window
	$origR = $CifOrigL+50;

	# Left hand titles
	openPrivButton ($DialogPrefix . "luser",$origL,$origT,48,$CifRowHeight,1,-1,99,"Nickname");

	# Right hand titles
	openPrivButton ($DialogPrefix . "ruser",$origR,$origT,48,$CifRowHeight,1,-1,99,"Nickname");

	$mList = GetListOfPlayers("N");
	$mCount = arrayCount( $mList );
	$plyNum=0;
	WHILE ($plyNum < $mCount)
		$thisPlayer = GetPlayerInfo($mList[$plyNum]);
		$uName = $mList[$plyNum];
		$uUCID = $thisPlayer["UCID"];
		$uNick = $thisPlayer["NickName"];
		$Pref = $DialogPrefix . $uUCID . "_";

		$IsOdd = $plyNum & 1;
		IF ($IsOdd == 0)	# Check if we are on left or right side
		THEN
			$origT = $origT + $CifRowHeight;
			$origCol = $origL;
		ELSE
			$origCol=$origR;
		ENDIF
		openPrivButton ($Pref . "hUser",$origCol,$origT,34,$CifRowHeight,1,-1,96,"^7". $uNick);
		openPrivButton ($Pref . "info",$origCol+34,$origT,14,$CifRowHeight,1,-1,33,"^7Info",DoWhoMemberInfo);
		$plyNum=$plyNum+1;
	ENDWHILE
EndSub

Sub DoWhoMemberInfo ( $KeyFlags, $id )
	$rowHeight = 5;
	$origT = $CifOrigT + 1;
	$DialogPrefix = split( $id,"_",0 ) . "_";
	$Ucid = ToNum(split( $id,"_",1 ));
	$thisPlayer = GetPlayerInfo();
	$thatPlayer = GetPlayerInfo( GetPlayerVarByUcid($Ucid, "UserName") );

	closeButtonRegex ($thisPlayer["UserName"], $DialogPrefix . ".*");

	openPrivButton ( $DialogPrefix . "statsdetails", 73, 48, 90, 6, 5, -1, 16, langEngine ( "%{main_statsdetails}%", $thatPlayer["UserName"], $thatPlayer["NickName"], $thatPlayer["PosAbs"], $thatPlayer["PBDrift"], $thatPlayer["Car"], getLapperVar("LongTrackName"), getLapperVar("ShortTrackName"), NumToMSH ($thatPlayer["PBLapTime"]), NumToMSH ($thatPlayer["Tpb"]), $thatPlayer["Laps"], $thatPlayer["Dist"], $thatPlayer["UnitDist"] ) );
	
	openPrivButton ( $DialogPrefix . "qualdetails", 73, 99, 90, 6, 5, -1, 32, langEngine( "%{main_qualdetails}%", $thatPlayer["PosQual"], $thatPlayer["GroupQual"], getLapperVar("ShortDate"), getLapperVar("ShortTime") ) );

#	openPrivButton ( $DialogPrefix . "hInfo1",$CifOrigL+1,$origT,98,5,5,-1,32,langEngine( "%{info_header_1}%") );
	
	# Racer Name
#	$origT = $origT + $CifRowHeight; $iType = "Name";
#	openPrivButton ( $DialogPrefix . "h" . $iType,$CifOrigL,$origT,50,5,5,-1,ISB_RIGHT,langEngine( "%{info_name}%") );
#	openPrivButton ( $DialogPrefix . "v" . $iType,$CifOrigL+50,$origT,50,5,5,-1,64,"^3" . $thatPlayer["UserName"] . "(^8" . $thatPlayer["NickName"] . "^3)");
	# Member Type
#	$origT = $origT + $CifRowHeight; $iType = "Member";
#	openPrivButton ( $DialogPrefix . "h" . $iType,$CifOrigL,$origT,50,5,5,-1,ISB_RIGHT,langEngine( "%{info_membertype}%") );
#	openPrivButton ( $DialogPrefix . "v" . $iType,$CifOrigL+50,$origT,50,5,5,-1,64,"^3" . GetMemberType($thatPlayer["UserName"]) );

#	$origT = $origT + ( $CifRowHeight * 2 );
#	openPrivButton ( $DialogPrefix . "hInfo2",$CifOrigL+1,$origT,98,5,5,-1,32,langEngine( "%{info_header_2}%") );
	
	# Racer Stats
#	$origT = $origT + $CifRowHeight; $iType = "Dist";
#	openPrivButton ( $DialogPrefix . "h" . $iType,$CifOrigL,$origT,50,5,5,-1,ISB_RIGHT,langEngine( "%{info_distance}%") );
#	openPrivButton ( $DialogPrefix . "v" . $iType,$CifOrigL+50,$origT,50,5,5,-1,64,"^3" . $thatPlayer["UserName"] . "(^8" . $thatPlayer["NickName"] . "^3)");

EndSub

Lang "EN" # Race Events messages
	info_header_1 = "^7Detailed Player Information";
	info_name = "^7Racer Name:";
	info_membertype = "^7Member Type:";
	info_header_2 = "^7Player Statistics";
	info_distance = "^7Total Distance:";
	main_statsdetails = "^7Username: ^3{0}^7 - Nickname: {1}"
		. "%nl%"
		. "%nl%^7Your actual friendly Position (all visitors / all vehicles): ^3{2}"
		. "%nl%^7Your current best Drift Score (in ^3{4}^7): ^3{3}"
		. "%nl%"
		. "%nl%^7Current Track: ^3{5}^0 [ {6} ]"
		. "%nl%^7Your current PB Laptime with this combo: ^3{7}"
		. "%nl%^7Theoretical PB: ^3{8}"
		. "%nl%^7You've done: ^3{9} ^7laps, which is approx ^3{10} ^7{11}"
		. "%nl%";
	main_qualdetails = "%nl%"
		. "^4Q u a l i f i c a t i o n   D e t a i l s:"
		. "%nl%^6Current qualification position: ^3{0}"
		. "%nl%^6Current GROUP qualification position: ^3{1}"
		. "%nl%";
EndLang
